## Remove Journal Logs

```
sudo journalctl --vacuum-size=50M
```

Only keep 50mb of latest logs, and delete the rest.

Set max log file for journal, edit `/etc/systemd/journald.conf`, set `SystemMaxUse` to `50M` then save.

Restart service:

```
sudo systemctl restart systemd-journald
```

## Rotate logs

```
sudo logrotate -vf /etc/logrotate.conf
```

This should rotate the log files (so kern.log becomes kern.log.1); and you can then delete kern.log.1 etc to free up the disk space.

```
sudo find /var/log -type f -name "*.log.*.gz" -delete
```

## Search BIG files

Install NCDU

```
sudo apt-get install ncdu
```

Search for big files

```
sudo ncdu /
```

Delete only unused files, don't delete system file!

## Remove unused docker overlays

```
docker system prune -a --volumes
```