var assets_list = [
	{
		"Name": "Bitcoin",
		"Pair": "btc_idr",
		"Code": "BTC"
	},
	{
		"Name": "Cardano",
		"Pair": "ada_idr",
		"Code": "ADA"
	},
	{
		"Name": "Bitcoin Diamon",
		"Pair": "bcd_idr",
		"Code": "BCD"
	},
	{
		"Name": "Bitcoin Cash",
		"Pair": "bch_idr",
		"Code": "BCH"
	},
	{
		"Name": "Bitcoin Gold",
		"Pair": "btg_idr",
		"Code": "BTG"
	},
	{
		"Name": "Ethereum",
		"Pair": "eth_idr",
		"Code": "ETH"
	},
	{
		"Name": "Ethereum Classic",
		"Pair": "etc_idr",
		"Code": "ETC"
	},
	{
		"Name": "IGNIS",
		"Pair": "ignis_idr",
		"Code": "IGNIS"
	},
	{
		"Name": "Litecoin",
		"Pair": "ltc_idr",
		"Code": "LTC"
	},
	{
		"Name": "NXT",
		"Pair": "nxt_idr",
		"Code": "NXT"
	},
	{
		"Name": "Stellar Lumens",
		"Pair": "str_idr",
		"Code": "XLM"
	},
	{
		"Name": "Tokenomy",
		"Pair": "ten_idr",
		"Code": "TEN"
	},
	{
		"Name": "Waves",
		"Pair": "waves_idr",
		"Code": "WAVES"
	},
	{
		"Name": "Ripple",
		"Pair": "xrp_idr",
		"Code": "XRP"
	},
	{
		"Name": "ZCoin",
		"Pair": "xzc_idr",
		"Code": "XZC"
	}
];

function indodax_thousand_separator(nStr) {
	nStr += '';
	x = nStr.split('.');
	x1 = x[0];
	x2 = x.length > 1 ? '.' + x[1] : '';
	var rgx = /(\d+)(\d{3})/;
	while (rgx.test(x1)) {
		x1 = x1.replace(rgx, '$1' + '.' + '$2');
	}
	return x1 + x2;
}

function indodax_http_get_async(Url, callback, item) {
    var xmlHttp = new XMLHttpRequest();
    xmlHttp.onreadystatechange = function() { 
		if (xmlHttp.readyState == 4 && xmlHttp.status == 200)
			callback(JSON.parse(xmlHttp.responseText), item);
		}
    xmlHttp.open("GET", Url, true); // true for asynchronous 
    xmlHttp.send(null);
}

function indodax_render_data(response, data) {
	var table_list = document.getElementById("indodax-data-list");
	table_list.innerHTML += '<tr><td><span class="indodax-info-code">' 
	+data.Code+ 
	'</span></td><td><span class="indodax-info-name">' 
	+data.Name+ 
	'</span></td><td><span class="indodax-info-last">IDR ' 
	+indodax_thousand_separator(response.ticker.last)+ 
	'</span></td><td><span class="indodax-info-high">' 
	+indodax_thousand_separator(response.ticker.high)+ 
	'</span> <span class="indodax-info-separator">/</span><span class="indodax-info-low">' 
	+indodax_thousand_separator(response.ticker.low)+ 
	'</span></td></tr>';
}

function indodax_get_data(assets) {
	for (var i in assets) {
		var item 	= assets[i];
		var a_pair 	= item.Pair;
		var Url 	= "https://indodax.com/api/" +a_pair+ "/ticker";
		indodax_http_get_async(Url, indodax_render_data, item);
	}
}

// Action
indodax_get_data(assets_list);