from flask import Flask
from helper import ObjectIDConverter, objectid

app = Flask(__name__)

# Register ObjectIDConverter
app.url_map.converters['ObjectID'] = ObjectIDConverter

@app.route('/')
def index():
	return 'Index Page'

@app.route('/profile/<ObjectID:id>')
def profile(id):
	Output = 'Profile ID: %s' % (id)
	return Output

@app.route('/user/<id>')
def user(id):
	# Validate ObjectID
	UserID = objectid(id)
	if UserID:
		Output = 'Profile ID: %s' % (UserID)
	else:
		Output = 'Invalid UserID'

	return Output

# Run
if __name__ == "__main__":
	app.run()