from selenium import webdriver
from selenium.webdriver.common.keys import Keys
from selenium.webdriver.common.by import By
from selenium.webdriver.support.ui import WebDriverWait
from selenium.webdriver.support import expected_conditions as EC
from time import time, sleep
import json, os

def answer_question(driver):
	# Output
	Output = {}

	# Start
	BtnStart = WebDriverWait(driver, 30).until(
		EC.presence_of_element_located((By.XPATH, "//a[@class='kie']"))
	)
	driver.execute_script("arguments[0].click();", BtnStart)

	# Wait Question
	sleep(5)

	# Question
	Question = WebDriverWait(driver, 30).until(
		EC.presence_of_element_located((By.CLASS_NAME, "size-24"))
	)
	print(" * Question:", Question.text)
	Output["Question"] = Question.text

	# Wait AnswerColumn
	sleep(5)

	# Column
	AnswerColumn = driver.find_elements_by_name("jwb[]")
	print(" * Total Column:", len(AnswerColumn))
	for Column in AnswerColumn:
		Value = Column.get_property("value")
		if not Value:
			Column.clear()
			Column.send_keys("#")

	# Press Yes
	BtnOK = driver.find_element_by_id("cmdOk")
	driver.execute_script("arguments[0].click();", BtnOK)
	BtnLock = driver.find_element_by_id("cmdKunci")
	driver.execute_script("arguments[0].click();", BtnLock)
	BtnYes = driver.find_element_by_id("cmdJawabanBenar")
	driver.execute_script("arguments[0].click();", BtnYes)

	# Wait for Answer
	sleep(10)

	# Column
	RealAnswer = driver.find_elements_by_name("jawabanbenar")
	Answer = []
	for Column in RealAnswer:
		Value = Column.get_property("value")
		Answer.append(Value)
	print(" * Answer:", Answer)
	Output["Answer"] = Answer

	# Accept
	driver.execute_script("terima();")
	# Sleep
	sleep(5)
	# Return
	return Output

def run():
	# Data
	Data = []
	try:
		# Init
		driver = webdriver.Firefox()
		driver.get("https://www.teka-teki-sulit.dwicandra.xyz/")
		driver.execute_script("mode_biasa('user');")

		# Answer
		for I in range(1, 33):
			print(" * Question Number:", I)
			Answer = answer_question(driver)
			if Answer:
				Data.append(Answer)
			print("")

	except Exception as e:
		raise e

	finally:
		# Dump
		Filename = str(int(time())) + '.txt'
		with open(Filename, 'w') as outfile:
			json.dump(Data, outfile)

		# Quit
		driver.quit()

# Run!
run()