from flask_wtf import FlaskForm
from wtforms import StringField, SelectMultipleField
from wtforms.widgets import ListWidget, CheckboxInput
from wtforms.validators import Required

class MultiCheckboxField(SelectMultipleField):
	widget			= ListWidget(prefix_label=False)
	option_widget	= CheckboxInput()

class FormProject(FlaskForm):
	Code	= StringField('Code', [Required(message='Please enter your code')])
	Tasks	= MultiCheckboxField('Proses', [Required(message='Please tick your task')], choices=[('nyapu','Nyapu'), ('ngepel','Ngepel')])