# Nginx 413 Request Entity Too Large

This error occurs when the user uploads or sends a request above `client_max_body_size` value on nginx configuration.

#### Nginx configuration

Edit nginx.conf:

```
sudo nano /etc/nginx/nginx.conf
```
Add the code below between `server { }`

```
client_max_body_size 8M;
```

Note: Replace 8M with the size you want.

Save by pressing the button <kbd>CTRL</kbd>+<kbd>O</kbd>, then press <kbd>Enter</kbd>. To exit press <kbd>CTRL</kbd>+<kbd>X</kbd>.

Then, reload nginx service.

```
sudo service nginx restart
```